/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */

#ifndef IDISPLAY_H
#define IDISPLAY_H

#include "color3.h"

/*
 * IDisplay is a pure abstract class which displays the Turing reactor.
 * (actually, it may display anything else).
 *
 * The idea is to be able to use any 2D graphics API to do the job.
 * Derive IDisplay to the class of your choice and reimplement
 * drawPixel() and update(), which actually renders the graphics, using
 * the API of your choice.
 *
 * TODO
 * - Allow parametrable resolution
 * - A possible modification would be to implement a display object knowing
 * how to deal with an object of class Grid so that 3D, ASCII or any other type of
 * rendering becomes possible.
 */

class IDisplay
{
public:
	// Fills the screen in the color passed as an argument
	//   nb: the color can be passed as  Color3 object or integer RGB components
	virtual void clearScreen( Color3 ) = 0;
	virtual void clearScreen( int, int, int ) = 0;

	// Fills pixel at position (x,y) with color c
	virtual void drawPixel( int x,int y, Color3 c ) = 0;

	// Renders the graphics buffer
	virtual void update() = 0;
};

#endif