/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#ifndef MODELS_H
#define MODELS_H

#include "qreactor_grayscott.h"
#include "qreactor_turk.h"

// This function creates the appropriate reactor class according to
// the combobox/dropdown menu choice
void TuringQTwin32Window::selectReactor( int n )
{
	// suppress and disconnect current reactor, if there is one
	if( m_reactor )
	{
		disconnect( m_specificConfigAction, SIGNAL( activated() ), m_reactor, SLOT( specificConfig() ) );
		delete m_specificConfigAction;
		delete m_reactor;
		m_reactor = NULL;
	}
	
	// reactor type taken from combobox
	n = this->m_displayWidget->m_reactorComboBox->currentItem();
	

	// creates the object and connects the specific menu action to its dialog box
	switch( n )
	{
	case 0: // none
		setStatus( EMPTY );
		break;
	case 1: // Gray-Scott model
		m_reactor = new QReactor_grayscott( this, 32,32, SDLDisplay::instance(), 0.04, 0.0625 );
		m_specificConfigAction = new QAction( "Gray-Scott model...", "Gray-Scott &model...", CTRL+Key_M, this, "action_config_specific" );
		setStatus( IDLE );
		break;
	case 2: // Turk model
		m_reactor = new QReactor_turk( this, 32,32, SDLDisplay::instance(), 0.03125, 0.05 );
		m_specificConfigAction = new QAction( "Turk model...", "Turk &model...", CTRL+Key_M, this, "action_config_specific" );
		setStatus( IDLE );
		break;
	default:
		setStatus( EMPTY );
		break;
	}

	// adds the specific menu action to the "Paramtres" menu
	if( n != 0 )
	{
		m_specificConfigAction->addTo( m_configMenu );
		connect( m_specificConfigAction, SIGNAL( activated() ), m_reactor, SLOT( specificConfig() ) );
	}
}

#endif