/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#include "qreactor.h"

#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qlabel.h>

QReactor::QReactor( TuringQTwin32Window *window, int w, int h, IDisplay *d )
: QObject(), Reactor( w, h, d ), m_mainWindow( window )
{
	m_runTimer = new QTimer( this );
    connect( m_runTimer, SIGNAL( timeout() ), SLOT( updateReaction() ) );

	connect( (QObject *)m_mainWindow->m_playbackWidget->m_startButton,
		SIGNAL( clicked() ),
		(QObject *)this,
		SLOT( start() )
		);
	connect( (QObject *)m_mainWindow->m_playbackWidget->m_stopButton,
		SIGNAL( clicked() ),
		(QObject *)this,
		SLOT( stop() )
		);
	connect( (QObject *)m_mainWindow->m_playbackWidget->m_resetButton,
		SIGNAL( clicked() ),
		(QObject *)this,
		SLOT( reset() )
		);
	connect( (QObject *)m_mainWindow->m_playbackWidget->m_stepButton,
		SIGNAL( clicked() ),
		(QObject *)this,
		SLOT( step() )
		);
}

void QReactor::start()
{
	m_mainWindow->setStatus( TuringQTwin32Window::RUNNING );
    m_runTimer->start( 0, FALSE );
}

void QReactor::stop()
{
	m_runTimer->stop();
	setStopStep( -1 );
	setCurrentStep( 0 );
	m_mainWindow->setStatus( TuringQTwin32Window::IDLE );
}

void QReactor::reset()
{
	m_runTimer->stop();
	m_mainWindow->setStatus( TuringQTwin32Window::IDLE );
	m_mainWindow->m_playbackWidget->m_stepNumberTextLabel->setNum( 0 );
	resetGrids();
	show();
}

void QReactor::step()
{
	QString ns;
	bool ok;
	int n;

	ns = m_mainWindow->m_playbackWidget->m_stepLineEdit->text();
	n = ns.toInt( &ok );
	if( ok && ( n>0 ) )
	{
		setStopStep( n );
		start();
	}
}

void QReactor::updateReaction()
{
	int n = m_mainWindow->m_playbackWidget->m_stepNumberTextLabel->text().toInt();
	m_mainWindow->m_playbackWidget->m_stepNumberTextLabel->setNum( n+1 );
	Reactor::update( 0 );
}
/* A VIRER
void QReactor::initQReactor()
{
}
*/