/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#ifndef QREACTOR_H
#define QREACTOR_H

#include <qobject.h>
#include "reactor.h"
#include <qtimer.h>

#include "turingqtwin32window.h"

/*
 * The QReactor class accounts for the Qt-ed version of the Reactor class
 * allowing it to be reactive to a Qt GUI.
 * It deals with start, stop and reset events for the reaction
 */

class QReactor : public QObject, public Reactor
{
	Q_OBJECT

public:
	QReactor( TuringQTwin32Window *window, int w, int h, IDisplay *d );

	// This QTimer is used as an event trigger : when in 'running' mode
	// it continuously triggers the updateReaction() slot ; when in 'idle'
	// mode, nothing happens
	QTimer *m_runTimer;

public slots:
	// Initiates the QTimer
	void start();
	// Stops the QTimer
	void stop();
	// Re-initializes the reaction
	void reset();
	// Runs the reaction for a specific amount of steps (available via the control panel)
	void step();

	// Performs one reaction step 
	void updateReaction();

	// Pops up the dialog box for specific parameters ; it is pure virtual
	virtual void specificConfig() = 0;

protected:
	// Pointer to the main window for interaction purposes
	TuringQTwin32Window *m_mainWindow;
//	void initQReactor();
};

#endif
