/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#include "qreactor_grayscott.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include "qreactor_grayscottspecificconfigdialogimpl.h"

QReactor_grayscott::QReactor_grayscott( TuringQTwin32Window *window, int w, int h, IDisplay *d, double F, double k ) : QReactor( window, w, h, d ), m_F( F ), m_k( k )
{
	m_gradient = false;
	m_Fmax = 0.08;
	m_Fmin = 0;

	m_kmax = 0.07;
	m_kmin = 0.04;
}

QReactor_grayscott::~QReactor_grayscott()
{
}

double QReactor_grayscott::funcA( int i, int j )
{
	double pF;
	if( m_gradient )
	{
		double pi = (double)i/(double)m_A.getWidth();
		double pj = (double)j/(double)m_A.getHeight();
		pF = m_Fmin + pj*(m_Fmax - m_Fmin);
	} else {
		pF = m_F;
	}

	double a = m_A.getValue( i, j );
	double b = m_B.getValue( i, j );

	return pF*(1-a) - a * b*b;
}

double QReactor_grayscott::funcB( int i, int j )
{
	double pF, pk;
	if( m_gradient )
	{
		double pi = (double)i/(double)m_A.getWidth();
		double pj = (double)j/(double)m_A.getHeight();
		pF = m_Fmin + pj*(m_Fmax - m_Fmin);
		pk = m_kmin + pi*(m_kmax - m_kmin);
	} else {
		pF = m_F;
		pk = m_k;
	}

	double a = m_A.getValue( i, j );
	double b = m_B.getValue( i, j );

	return a * b*b - (pF+pk)*b;
}

void QReactor_grayscott::specificConfig()
{
	QReactor_grayscottSpecificConfigDialog *d = new QReactor_grayscottSpecificConfigDialog( m_mainWindow, "dialog_config_specifique", true, WStyle_Customize | WStyle_NormalBorder );
	d->setGeometry( m_mainWindow->x()+300, m_mainWindow->y()+30, d->baseSize().width(), d->baseSize().height() );
	d->m_FLineEdit->setText( QString().setNum( m_F ) );
	d->m_FLineEdit->setEnabled( !m_gradient );
	d->m_kLineEdit->setText( QString().setNum( m_k ) );
	d->m_kLineEdit->setEnabled( !m_gradient );
	d->CheckBox5->setChecked( m_gradient );

	if( d->exec() )
	{
		bool ok;
		QString ds;
		double dd;
		
		ds = d->m_FLineEdit->text();
		dd = ds.toDouble( &ok );
		if( ok )
		{
			m_F = dd;
		}
		
		ds = d->m_kLineEdit->text();
		dd = ds.toDouble( &ok );
		if( ok )
		{
			m_k = dd;
		}

		m_gradient = d->CheckBox5->isChecked();
		if( m_gradient )
			this->setTorusMode( 0 );
	}
	else
	{
	}
	delete d;
}