/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#ifndef QREACTOR_GRAYSCOTT_H
#define QREACTOR_GRAYSCOTT_H

#include "qreactor.h"
#include "sdldisplay.h"

/*
 * The QReactor_grayscott class accounts for the implementation of the Gray-Scott model
 */

class QReactor_grayscott : public QReactor
{
	Q_OBJECT
public:
	QReactor_grayscott( TuringQTwin32Window *window, int w = 32, int h = 32, IDisplay * = SDLDisplay::instance(), double = 0.04, double = 0.0625 );
	~QReactor_grayscott();

public slots:
	void specificConfig();

protected:
	double m_F, m_k;
	double m_Fmax, m_Fmin;
	double m_kmax, m_kmin;
	bool m_gradient;

	double funcA( int, int );
	double funcB( int, int );
};

#endif
