/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#include "qreactor_turk.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include "qreactor_turkspecificconfigdialogimpl.h"

QReactor_turk::QReactor_turk( TuringQTwin32Window *window, int w, int h, IDisplay *d, double s, double db ) : QReactor( window, w, h, d ), m_s( s ), m_db( db )
{
	m_gradient = false;
	m_smin = 0;
	m_smax = 1;

	m_dbmin = 0.01;
	m_dbmax = 3.0;

	m_Da = 0.25;
	m_Db = 0.0625;
}

QReactor_turk::~QReactor_turk()
{
}

double QReactor_turk::funcA( int i, int j )
{
	double ps;
	if( m_gradient )
	{
		double pi = (double)i/(double)m_A.getWidth();
		double pj = (double)j/(double)m_A.getHeight();
		ps = m_smin + (pi+pj/2)*(m_smax - m_smin);
	} else {
		ps = m_s;
	}

	double a = m_A.getValue( i, j );
	double b = m_B.getValue( i, j );

	return (ps*(16 - a*b));
}

double QReactor_turk::funcB( int i, int j )
{
	double dRM = (double)RAND_MAX;
	double beta;
	double ps, pdb;
	if( m_gradient )
	{
		double pi = (double)i/(double)m_A.getWidth();
		double pj = (double)j/(double)m_A.getHeight();
		ps = m_smin + pi*(m_smax - m_smin);
		pdb = m_dbmin + pj*(m_dbmax - m_dbmin);
	} else {
		ps = m_s;
		pdb = m_db;
	}

	double a = m_A.getValue( i, j );
	double b = m_B.getValue( i, j );

	beta = 12 + pdb*2*(1 - ((double)rand())/dRM);
	return (ps*(a*b - b - beta));
}

void QReactor_turk::specificConfig()
{
/*	QReactor_turkSpecificConfigDialog *d = new QReactor_turkSpecificConfigDialog( m_mainWindow, "dialog_config_specifique", true, WStyle_Customize | WStyle_NormalBorder );
	d->setGeometry( m_mainWindow->x()+300, m_mainWindow->y()+30, d->baseSize().width(), d->baseSize().height() );
	d->m_FLineEdit->setText( QString().setNum( m_F ) );
	d->m_FLineEdit->setEnabled( !m_gradient );
	d->m_kLineEdit->setText( QString().setNum( m_k ) );
	d->m_kLineEdit->setEnabled( !m_gradient );
	d->CheckBox5->setChecked( m_gradient );

	if( d->exec() )
	{
//		bool g;
		bool ok;
		QString ds;
		double dd;
		
		ds = d->m_FLineEdit->text();
		dd = ds.toDouble( &ok );
		if( ok )
		{
			m_F = dd;
		}
		
		ds = d->m_kLineEdit->text();
		dd = ds.toDouble( &ok );
		if( ok )
		{
			m_k = dd;
		}

		m_gradient = d->CheckBox5->isChecked();
		if( m_gradient )
			this->setTorusMode( 0 );
	}
	else
	{
	}
	delete d;*/
}

void QReactor_turk::resetGrids()
{
	double dRM = (double)RAND_MAX;
//	double a, b;
//	int i, j;
	double ia = 0.1, ib = 0.5;
	double id = 0.1;

	int w = getWidth();
	int h = getHeight();


	for( int k = 0; k<w; k++ )
	for( int l = 0; l<h; l++ )
	{
		m_A.setValue( k, l, 4.0 );
		m_B.setValue( k, l, 4.0 );
	}
}
