/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#ifndef QREACTOR_turk_H
#define QREACTOR_turk_H

#include "qreactor.h"
#include "sdldisplay.h"

/*
 * The QReactor_turk class accounts for the implementation of Turk model
 *   NB : not functionnal yet
 */

class QReactor_turk : public QReactor
{
	Q_OBJECT
public:
	QReactor_turk( TuringQTwin32Window *window, int w = 32, int h = 32, IDisplay * = SDLDisplay::instance(), double = 0.04, double = 0.0625 );
	~QReactor_turk();

	void resetGrids();
public slots:
	void specificConfig();

protected:
	double m_s;
	double m_smin, m_smax;
	double m_db;
	double m_dbmin, m_dbmax;
	bool m_gradient;

	double funcA( int, int );
	double funcB( int, int );
};

#endif
