/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#ifndef SDLDISPLAY_H
#define SDLDISPLAY_H

#include "idisplay.h"

#include <SDL/SDL.h>

/*
 * SDLDisplay reimplements IDisplay with the SDL API (www.libsdl.org)
 */

class SDLDisplay : public IDisplay
{
public:
	~SDLDisplay();

	// Returns a pointer to the statix unique instance of the display
	//   nb: first call to SDLDisplay::instance() will pop up the graphics window
	static SDLDisplay *instance();

	// reimplemented from IDisplay
	void clearScreen( Color3 = Color3( 0, 0, 0 ) );
	void clearScreen( int = 0, int = 0, int = 0 );
	void drawPixel( int, int, Color3 );
	void update();

	// Specific lock/unlock instructions for SDL_Surface structures
	// which allow faster rendering
	void lock();
	void unlock();

private:
	/*
	 * Singleton design pattern allows at most only 1 SDLDisplay to exist
	 * at any time.
	 * To access the display object, always use SDLDisplay::instance(), no
	 * matter you already called it before
	 */
	SDLDisplay();
	static SDLDisplay *pinstance;

	bool initSDL();

	SDL_Surface *m_screen;
	bool isLocked;
	int xRes, yRes;
};

#endif