/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#include "turingqtwin32window.h"

#include <qapplication.h>

#include <qaction.h>
#include <qpopupmenu.h>
#include <qmenubar.h>

#include "qgeneralconfigdialogimpl.h"
#include "qdisplayconfigdialogimpl.h"
#include "qaboutdialogimpl.h"

#include "sdldisplay.h"

#include <qgroupbox.h>
#include <qcombobox.h>

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

#include <qsizepolicy.h>

#include "models.h"

TuringQTwin32Window::TuringQTwin32Window( QWidget* parent, const char* name, WFlags f )
	: QMainWindow( parent, name, f )
{
	setGeometry( QRect( 25, 50, 200, 170 ) );
	setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed ) );

	// menu FICHIER
    m_fileMenu = new QPopupMenu( this, "menu_fichier" );
    menuBar()->insertItem( "&Fichier", m_fileMenu, ALT+Key_F );

    m_fileQuitAction = new QAction( "Quitter", "&Quitter", CTRL+Key_Q, this, "quit" );
	connect( m_fileQuitAction, SIGNAL( activated() ), qApp, SLOT( quit() ) );
    m_fileQuitAction->addTo( m_fileMenu );

	// menu PARAMETRES
	m_configMenu = new QPopupMenu( this, "menu_config" );
	menuBar()->insertItem( "&Configurer", m_configMenu, ALT+Key_C );

	m_generalConfigAction = new QAction( "General...", "&General...", CTRL+Key_G, this, "action_config_general" );
	m_generalConfigAction->addTo( m_configMenu );
	m_generalConfigAction->setEnabled( false );
	connect( m_generalConfigAction, SIGNAL( activated() ), this, SLOT( generalConfig() ) );

	m_displayConfigAction = new QAction( "Affichage...", "&Affichage...", CTRL+Key_A, this, "action_config_affichage" );
	m_displayConfigAction->addTo( m_configMenu );
	m_displayConfigAction->setEnabled( false );
	connect( m_displayConfigAction, SIGNAL( activated() ), this, SLOT( displayConfig() ) );

	// menu FICHIER
    QPopupMenu *helpMenu = new QPopupMenu( this, "menu_aide" );
    menuBar()->insertItem( "&?", helpMenu, ALT+Key_F );

    QAction *aboutAction = new QAction( "A propos...", "&A propos", CTRL+SHIFT+Key_A, this, "about" );
	connect( aboutAction, SIGNAL( activated() ), this, SLOT( about() ) );
    aboutAction->addTo( helpMenu );

	m_centralWidget = new QWidget( this );

	m_displayWidget = new QDisplayWidget( m_centralWidget );
	m_displayWidget->setGeometry( 5, 5, 200, 20 );

	m_playbackWidget = new QPlaybackWidget( m_centralWidget );
	m_playbackWidget->setGeometry( 5, 30, 200, 200 );

//	QPushButton b = new QPushButton( "TEMP", m_centralWidget );

//	m_reactorWidget = new QReactorGeneralWidget( m_centralWidget );
//	m_reactorWidget->setGeometry( 5, 250, 200, 300 );

	setCentralWidget( m_centralWidget );

	connect( (QObject *)m_displayWidget->m_reactorComboBox, SIGNAL( activated( int ) ), this, SLOT( selectReactor( int ) ) );

	m_reactor = NULL;

	setStatus( EMPTY );

	SDLDisplay::instance()->clearScreen( 0, 0, 0 );
	SDLDisplay::instance()->update();
}
/*
void TuringQTwin32Window::selectReactor( int n )
{
	if( m_reactor )
	{
		disconnect( m_specificConfigAction, SIGNAL( activated() ), m_reactor, SLOT( specificConfig() ) );
		delete m_specificConfigAction;
		delete m_reactor;
		m_reactor = NULL;
	}
	
	n = this->m_displayWidget->m_reactorComboBox->currentItem();
	
	switch( n ) // In case of additional reactor implementations
	{
	case 0:
		setStatus( EMPTY );
		break;
	case 1:
		m_reactor = new QReactor_grayscott( this, 32,32, SDLDisplay::instance(), 0.04, 0.0625 );
		m_specificConfigAction = new QAction( "Gray-Scott model...", "Gray-Scott &model...", CTRL+Key_M, this, "action_config_specific" );
		setStatus( IDLE );
		break;
	case 2:
		m_reactor = new QReactor_turk( this, 32,32, SDLDisplay::instance(), 0.03125, 0.05 );
		m_specificConfigAction = new QAction( "Turk model...", "Turk &model...", CTRL+Key_M, this, "action_config_specific" );
		setStatus( IDLE );
		break;
	default:
		setStatus( EMPTY );
		break;
	}

	if( n != 0 )
	{
		m_specificConfigAction->addTo( m_configMenu );
		connect( m_specificConfigAction, SIGNAL( activated() ), m_reactor, SLOT( specificConfig() ) );
	}
}
*/
void TuringQTwin32Window::setStatus( Status s )
{
	switch( s )
	{
	case EMPTY:
		this->m_displayConfigAction->setEnabled( false );
		this->m_generalConfigAction->setEnabled( false );
		this->m_displayWidget->m_reactorComboBox->setEnabled( true );
		this->m_playbackWidget->setEnabled( false );
		SDLDisplay::instance()->clearScreen( 0, 0, 0 );
		SDLDisplay::instance()->update();
		break;
	case IDLE:
		this->m_displayConfigAction->setEnabled( true );
		this->m_generalConfigAction->setEnabled( true );
		this->m_specificConfigAction->setEnabled( true );
		this->m_displayWidget->m_reactorComboBox->setEnabled( true );
		this->m_playbackWidget->setEnabled( true );
		m_reactor->show();
		break;
	case RUNNING:
		this->m_displayConfigAction->setEnabled( true );
		this->m_generalConfigAction->setEnabled( false );
		this->m_specificConfigAction->setEnabled( false );
		this->m_displayWidget->m_reactorComboBox->setEnabled( false );
		this->m_playbackWidget->setEnabled( true );
		m_reactor->show();
		break;
	default:
		break;
	}
}

void TuringQTwin32Window::generalConfig()
{
	if( !m_reactor )
		return;

	QGeneralConfigDialog *d = new QGeneralConfigDialog( this, "dialog_config_general", true, WStyle_Customize | WStyle_NormalBorder );
	d->setGeometry( x()+300, y()+30, d->baseSize().width(), d->baseSize().height() );
	d->m_ASpreadRateLineEdit->setText( QString().setNum( m_reactor->getASpreadRate() ) );
	d->m_BSpreadRateLineEdit->setText( QString().setNum( m_reactor->getBSpreadRate() ) );
	d->m_widthLineEdit->setText( QString().setNum( m_reactor->getWidth() ) );
	d->m_heightLineEdit->setText( QString().setNum( m_reactor->getHeight() ) );
	switch( m_reactor->getTorusMode() )
	{
	case 0:
		d->m_torusRadioNone->setChecked( true );
		break;
	case 1:
		d->m_torusRadioV->setChecked( true );
		break;
	case 2:
		d->m_torusRadioH->setChecked( true );
		break;
	case 3:
		d->m_torusRadioHV->setChecked( true );
		break;
	default:
		break;
	}

    if ( d->exec() )
	{
		QString ds, hs, ws;
		double f;
		int w, h, n;
		bool ok;

		int t =
			1 * (int)d->m_torusRadioNone->isChecked() +
			3 * (int)d->m_torusRadioH->isChecked() +
			2 * (int)d->m_torusRadioV->isChecked() +
			4 * (int)d->m_torusRadioHV->isChecked()
			- 1;
		m_reactor->setTorusMode( t );

		ds = d->m_ASpreadRateLineEdit->text();
		f = ds.toDouble( &ok );
		if( ok )
			m_reactor->setASpreadRate( f );
		ds = d->m_BSpreadRateLineEdit->text();
		f = ds.toDouble( &ok );
		if( ok )
			m_reactor->setBSpreadRate( f );
		
		ws = d->m_widthLineEdit->text();
		n = ws.toInt( &ok );
		if( ok )
			w = n;
		hs = d->m_heightLineEdit->text();
		n = hs.toInt( &ok );
		if( ok )
			h = n;
		if( ( w != m_reactor->getWidth() ) || ( h != m_reactor->getHeight() ) )
			m_reactor->setDimensions( w, h );
		
		m_reactor->show();
    }
    else
	{
    }
    delete d;
}

void TuringQTwin32Window::displayConfig()
{
	if( !m_reactor )
		return;
	
	QDisplayConfigDialog *d = new QDisplayConfigDialog( this, "dialog_config_affichage", true, WStyle_Customize | WStyle_NormalBorder );
	d->setGeometry( x()+300, y()+30, d->baseSize().width(), d->baseSize().height() );
	d->m_cellWidthLineEdit->setText( QString().setNum( m_reactor->getCellWidth() ) );
	d->m_cellSpacingLineEdit->setText( QString().setNum( m_reactor->getCellSpacing() ) );
	d->m_AcheckBox->setChecked( m_reactor->isVisibleA() );
	d->m_BcheckBox->setChecked( m_reactor->isVisibleB() );
	d->m_showStepLineEdit->setText( QString().setNum( m_reactor->getShowStep() ) );

    if ( d->exec() )
	{
		QString cws, css, sss;
		int cw, cs, ss;
		bool A, B, ok;
		cws = d->m_cellWidthLineEdit->text();
		css = d->m_cellSpacingLineEdit->text();
		A = d->m_AcheckBox->isChecked();
		B = d->m_BcheckBox->isChecked();
		sss = d->m_showStepLineEdit->text();
		
		cw = cws.toInt( &ok );
		if( ok )
			m_reactor->setCellWidth( cw );
		cs = css.toInt( &ok );
		if( ok )
			m_reactor->setCellSpacing( cs );
		
		m_reactor->setVisibleA( A );
		m_reactor->setVisibleB( B );
		
		ss = sss.toInt( &ok );
		if( ok )
			m_reactor->setShowStep( ss );
		
		m_reactor->show();
    }
    else
	{
    }
    delete d;
}
/*
void TuringQTwin32Window::step()
{
	QString ns;
	bool ok;
	int n;

	ns = this->m_playbackWidget->m_stepLineEdit->text();
	n = ns.toInt( &ok );
	if( ok && ( n>0 ) )
	{
		m_reactor->setStopStep( n );
		m_reactor->start();
	}
}
*/
void TuringQTwin32Window::about()
{
	QAboutDialog *d = new QAboutDialog( this, "dialog_about", true, WStyle_Customize | WStyle_NormalBorder );
//	d->setGeometry( x()+300, y()+30, d->baseSize().width(), d->baseSize().height() );

    if ( d->exec() )
	{
    }
    else
	{
    }
    delete d;
}
