/*
 *  Ce fichier fait partie intgrante du projet TuringQTwin32
 *
 *  auteur: Olivier Gies - olivier.gies@aist.enst.fr
 *
 *  Tous droits rservs
 */
#ifndef TURINGQTWIN32WINDOW_H
#define TURINGQTWIN32WINDOW_H

#include <qmainwindow.h>

#include "qdisplaywidget.h"
#include "qplaybackwidget.h"

#include <qpopupmenu.h>
#include <qaction.h>

class QReactor;

/*
 * The class TuringQTwin32Window is the application main windows. It inherits
 * from Qt's QMainWindow
 */

class TuringQTwin32Window : public QMainWindow
{
	Q_OBJECT
public:
	// cf. setStatus
	enum Status { EMPTY, IDLE, RUNNING };

	TuringQTwin32Window( QWidget* parent = 0, const char* name = 0, WFlags f = WType_TopLevel );

	// There is a unique reactor loaded at any time. Since QReactor abstracts
	// the model, only one variable can be used.
	QReactor *m_reactor;

	// GUI objects
	// nb: they are set public for convenience purposes
	QWidget *m_centralWidget;
	QDisplayWidget *m_displayWidget;
	QPlaybackWidget *m_playbackWidget;

	QPopupMenu *m_fileMenu;
    QAction *m_fileQuitAction;

	QPopupMenu *m_configMenu;
	QAction *m_generalConfigAction;
	QAction *m_displayConfigAction;
	QAction *m_specificConfigAction;

public slots:
	// Loads (or unloads) the select reactor in the drop-down menu
	void selectReactor( int = 0 );
	// This function deals at once with enabled/disabled states of all
	// the GUI components according to the current state
	void setStatus( Status );

	// Interfaces the general configuration dialog box with the reactor 
	// general parameters
	void generalConfig();
	// Interfaces the display configuration dialog box with the reactor 
	// display parameters
	void displayConfig();
	// Pops up the "A propos" dialog box
	void about();
};

#endif